/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.model.media;

import cn.ipokerface.weixin.model.media.MpArticle;
import cn.ipokerface.weixin.model.media.MultiMessageTuple;
import cn.ipokerface.weixin.model.media.NotifyMessageTuple;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MpNewsMessageTuple
implements MultiMessageTuple,
NotifyMessageTuple {
    private static final long serialVersionUID = 8853054484809101524L;
    private static final int MAX_ARTICLE_COUNT = 8;
    @JSONField(name="media_id")
    @XmlElement(name="MediaId")
    private String mediaId;
    @XmlTransient
    private LinkedList<MpArticle> articles;

    @Override
    public String getMessageType() {
        return "mpnews";
    }

    public MpNewsMessageTuple(String mediaId) {
        this.mediaId = mediaId;
        this.articles = new LinkedList();
    }

    public MpNewsMessageTuple(MpArticle ... articles) {
        this.articles = new LinkedList<MpArticle>(Arrays.asList(articles));
    }

    public MpNewsMessageTuple addArticle(String thumbMediaId, String title, String content) {
        return this.addArticle(new MpArticle(thumbMediaId, title, content));
    }

    public MpNewsMessageTuple addArticle(MpArticle ... articles) {
        for (MpArticle article : articles) {
            this.articles.add(article);
        }
        return this;
    }

    public MpNewsMessageTuple addFirstArticle(MpArticle article) {
        this.articles.addFirst(article);
        return this;
    }

    public MpNewsMessageTuple addLastArticle(MpArticle article) {
        this.articles.addLast(article);
        return this;
    }

    public MpNewsMessageTuple removeFirstArticle() {
        this.articles.removeFirst();
        return this;
    }

    public MpNewsMessageTuple removeLastArticle() {
        this.articles.removeLast();
        return this;
    }

    @JSONField(serialize=false)
    @XmlTransient
    public boolean isMaxCount() {
        return this.articles.size() == 8;
    }

    public List<MpArticle> getArticles() {
        if (this.articles.size() > 8) {
            return this.articles.subList(0, 8);
        }
        return this.articles;
    }

    @JSONField(serialize=false)
    @XmlTransient
    public List<MpArticle> getFullArticles() {
        return this.articles;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public String toString() {
        return "MpNews [articles=" + this.articles + ", mediaId=" + this.mediaId + "]";
    }
}

