/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.model.card;

import cn.ipokerface.weixin.model.card.CardCodeType;
import cn.ipokerface.weixin.model.card.CardColor;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CouponBase
implements Serializable {
    private static final long serialVersionUID = -5725424121330101716L;
    @JSONField(name="logo_url")
    private String logoUrl;
    @JSONField(name="brand_name")
    private String brandName;
    private String title;
    @JSONField(name="code_type")
    private CardCodeType codeType;
    @JSONField(name="color")
    private CardColor cardColor;
    private String notice;
    private String description;
    private JSONObject sku;
    @JSONField(name="date_info")
    private JSONObject date;
    @JSONField(name="use_custom_code")
    private Boolean useCustomCode;
    @JSONField(name="bind_openid")
    private Boolean bindOpenId;
    @JSONField(name="service_phone")
    private String servicePhone;
    @JSONField(name="location_id_list")
    private List<String> locationIds;
    @JSONField(name="use_all_locations")
    private boolean useAllLocation;
    @JSONField(name="center_title")
    private String centerTitle;
    @JSONField(name="center_url")
    private String centerUrl;
    @JSONField(name="center_sub_title")
    private String centerSubTitle;
    @JSONField(name="custom_url_name")
    private String customTitle;
    @JSONField(name="custom_url")
    private String customUrl;
    @JSONField(name="custom_url_sub_title")
    private String customSubTitle;
    @JSONField(name="promotion_url_name")
    private String promotionTitle;
    @JSONField(name="promotion_url")
    private String promotionUrl;
    @JSONField(name="promotion_url_sub_title")
    private String promotionSubTitle;
    private String source;
    @JSONField(name="get_limit")
    private int limitNum;
    @JSONField(name="can_share")
    private boolean canShare;
    @JSONField(name="can_give_friend")
    private boolean canGiveFriend;
    @JSONField(name="need_push_on_view")
    private Boolean needPushOnView;

    private CouponBase(Builder builder) {
        this.logoUrl = builder.logoUrl;
        this.brandName = builder.brandName;
        this.title = builder.title;
        this.codeType = builder.codeType;
        this.cardColor = builder.cardColor;
        this.notice = builder.notice;
        this.description = builder.description;
        this.sku = builder.sku;
        this.date = builder.date;
        this.useCustomCode = builder.useCustomCode;
        this.bindOpenId = builder.bindOpenId;
        this.servicePhone = builder.servicePhone;
        this.locationIds = builder.locationIds;
        this.useAllLocation = builder.useAllLocation;
        this.centerTitle = builder.centerTitle;
        this.centerUrl = builder.centerUrl;
        this.centerSubTitle = builder.centerSubTitle;
        this.customTitle = builder.customTitle;
        this.customUrl = builder.customUrl;
        this.customSubTitle = builder.customSubTitle;
        this.promotionTitle = builder.promotionTitle;
        this.promotionUrl = builder.promotionUrl;
        this.promotionSubTitle = builder.promotionSubTitle;
        this.source = builder.source;
        this.limitNum = builder.limitNum;
        this.canShare = builder.canShare;
        this.canGiveFriend = builder.canGiveFriend;
        this.needPushOnView = builder.needPushOnView;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public String getBrandName() {
        return this.brandName;
    }

    public String getTitle() {
        return this.title;
    }

    public CardCodeType getCodeType() {
        return this.codeType;
    }

    public CardColor getCardColor() {
        return this.cardColor;
    }

    public String getNotice() {
        return this.notice;
    }

    public String getDescription() {
        return this.description;
    }

    public JSONObject getSku() {
        return this.sku;
    }

    public JSONObject getDate() {
        return this.date;
    }

    public Boolean isUseCustomCode() {
        return this.useCustomCode;
    }

    public Boolean isBindOpenId() {
        return this.bindOpenId;
    }

    public String getServicePhone() {
        return this.servicePhone;
    }

    public List<String> getLocationIds() {
        return this.locationIds;
    }

    public boolean isUseAllLocation() {
        return this.useAllLocation;
    }

    public String getCenterTitle() {
        return this.centerTitle;
    }

    public String getCenterUrl() {
        return this.centerUrl;
    }

    public String getCenterSubTitle() {
        return this.centerSubTitle;
    }

    public String getCustomTitle() {
        return this.customTitle;
    }

    public String getCustomUrl() {
        return this.customUrl;
    }

    public String getCustomSubTitle() {
        return this.customSubTitle;
    }

    public String getPromotionTitle() {
        return this.promotionTitle;
    }

    public String getPromotionUrl() {
        return this.promotionUrl;
    }

    public String getPromotionSubTitle() {
        return this.promotionSubTitle;
    }

    public String getSource() {
        return this.source;
    }

    public int getLimitNum() {
        return this.limitNum;
    }

    public boolean isCanShare() {
        return this.canShare;
    }

    public boolean isCanGiveFriend() {
        return this.canGiveFriend;
    }

    public Boolean getNeedPushOnView() {
        return this.needPushOnView;
    }

    public String toString() {
        return "logoUrl=" + this.logoUrl + ", brandName=" + this.brandName + ", title=" + this.title + ", codeType=" + (Object)((Object)this.codeType) + ", cardColor=" + (Object)((Object)this.cardColor) + ", notice=" + this.notice + ", description=" + this.description + ", sku=" + this.sku + ", date=" + this.date + ", useCustomCode=" + this.useCustomCode + ", bindOpenId=" + this.bindOpenId + ", servicePhone=" + this.servicePhone + ", locationIds=" + this.locationIds + ", useAllLocation=" + this.useAllLocation + ", centerTitle=" + this.centerTitle + ", centerUrl=" + this.centerUrl + ", centerSubTitle=" + this.centerSubTitle + ", customTitle=" + this.customTitle + ", customUrl=" + this.customUrl + ", customSubTitle=" + this.customSubTitle + ", promotionTitle=" + this.promotionTitle + ", promotionUrl=" + this.promotionUrl + ", promotionSubTitle=" + this.promotionSubTitle + ", source=" + this.source + ", limitNum=" + this.limitNum + ", canShare=" + this.canShare + ", canGiveFriend=" + this.canGiveFriend;
    }

    public void cleanCantUpdateField() {
        this.brandName = null;
        this.sku = null;
        this.bindOpenId = null;
        this.useCustomCode = null;
    }

    public static final class Builder {
        private String logoUrl;
        private String brandName;
        private String title;
        private CardCodeType codeType;
        private CardColor cardColor;
        private String notice;
        private String description;
        private JSONObject sku = new JSONObject();
        private JSONObject date = new JSONObject();
        private boolean useCustomCode;
        private boolean bindOpenId;
        private String servicePhone;
        private List<String> locationIds;
        private boolean useAllLocation;
        private String centerTitle;
        private String centerUrl;
        private String centerSubTitle;
        private String customTitle;
        private String customUrl;
        private String customSubTitle;
        private String promotionTitle;
        private String promotionUrl;
        private String promotionSubTitle;
        private String source;
        private int limitNum;
        private boolean canShare;
        private boolean canGiveFriend;
        private boolean needPushOnView;

        public Builder() {
            this.date.put("type", (Object)CardActiveType.DATE_TYPE_PERMANENT);
            this.useAllLocation = true;
            this.canShare = true;
            this.canGiveFriend = true;
            this.limitNum = 50;
        }

        public Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        public Builder brandName(String brandName) {
            this.brandName = brandName;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder codeType(CardCodeType codeType) {
            this.codeType = codeType;
            return this;
        }

        public Builder cardColor(CardColor cardColor) {
            this.cardColor = cardColor;
            return this;
        }

        public Builder notice(String notice) {
            this.notice = notice;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder quantity(int quantity) {
            quantity = quantity > 100000000 ? 100000000 : quantity;
            this.sku.put("quantity", (Object)quantity);
            return this;
        }

        public Builder activeAt(Date beginTime, Date endTime) {
            this.date.clear();
            this.date.put("type", (Object)CardActiveType.DATE_TYPE_FIX_TIME_RANGE);
            this.date.put("begin_timestamp", (Object)(beginTime.getTime() / 1000L));
            this.date.put("end_timestamp", (Object)(endTime.getTime() / 1000L));
            return this;
        }

        public Builder activeAt(int days, int beginDays, Date endTime) {
            this.date.clear();
            this.date.put("type", (Object)CardActiveType.DATE_TYPE_FIX_TERM);
            this.date.put("fixed_term", (Object)days);
            this.date.put("fixed_begin_term", (Object)beginDays);
            this.date.put("end_timestamp", (Object)(endTime.getTime() / 1000L));
            return this;
        }

        public Builder activeAt(int days, int beginDays) {
            this.date.clear();
            this.date.put("type", (Object)CardActiveType.DATE_TYPE_FIX_TERM);
            this.date.put("fixed_term", (Object)days);
            this.date.put("fixed_begin_term", (Object)beginDays);
            return this;
        }

        public Builder useCustomCode(boolean useCustomCode) {
            this.useCustomCode = useCustomCode;
            return this;
        }

        public Builder bindOpenId(boolean bindOpenId) {
            this.bindOpenId = bindOpenId;
            return this;
        }

        public Builder servicePhone(String servicePhone) {
            this.servicePhone = servicePhone;
            return this;
        }

        public Builder locationIds(String ... locationIds) {
            this.locationIds.addAll(Arrays.asList(locationIds));
            this.useAllLocation = false;
            return this;
        }

        public Builder centerTitle(String centerTitle) {
            this.centerTitle = centerTitle;
            return this;
        }

        public Builder centerUrl(String centerUrl) {
            this.centerUrl = centerUrl;
            return this;
        }

        public Builder centerSubTitle(String centerSubTitle) {
            this.centerSubTitle = centerSubTitle;
            return this;
        }

        public Builder customTitle(String customTitle) {
            this.customTitle = customTitle;
            return this;
        }

        public Builder customUrl(String customUrl) {
            this.customUrl = customUrl;
            return this;
        }

        public Builder customSubTitle(String customSubTitle) {
            this.customSubTitle = customSubTitle;
            return this;
        }

        public Builder promotionTitle(String promotionTitle) {
            this.promotionTitle = promotionTitle;
            return this;
        }

        public Builder promotionUrl(String promotionUrl) {
            this.promotionUrl = promotionUrl;
            return this;
        }

        public Builder promotionSubTitle(String promotionSubTitle) {
            this.promotionSubTitle = promotionSubTitle;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder limitNum(int limitNum) {
            this.limitNum = limitNum;
            return this;
        }

        public Builder canShare(boolean canShare) {
            this.canShare = canShare;
            return this;
        }

        public Builder canGiveFriend(boolean canGiveFriend) {
            this.canGiveFriend = canGiveFriend;
            return this;
        }

        public Builder needPushOnView(boolean needPushOnView) {
            this.needPushOnView = needPushOnView;
            return this;
        }

        public CouponBase build() {
            return new CouponBase(this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum CardActiveType {
            DATE_TYPE_FIX_TIME_RANGE,
            DATE_TYPE_FIX_TERM,
            DATE_TYPE_PERMANENT;

        }
    }
}

