/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.model.card;

import cn.ipokerface.weixin.model.card.CardCoupon;
import cn.ipokerface.weixin.model.card.CashCoupon;
import cn.ipokerface.weixin.model.card.CouponAdvance;
import cn.ipokerface.weixin.model.card.CouponBase;
import cn.ipokerface.weixin.model.card.DiscountCoupon;
import cn.ipokerface.weixin.model.card.GeneralCoupon;
import cn.ipokerface.weixin.model.card.GiftCoupon;
import cn.ipokerface.weixin.model.card.GrouponCoupon;
import cn.ipokerface.weixin.model.card.MemberCard;

public final class CardCoupons {
    private CardCoupons() {
    }

    public static CouponBase.Builder customBase() {
        return new CouponBase.Builder();
    }

    public static CouponAdvance.Builder customAdvance() {
        return new CouponAdvance.Builder();
    }

    public static MemberCard.Builder customMemberCard() {
        return new MemberCard.Builder();
    }

    public static CardCoupon createCashCoupon(CouponBase.Builder builder, double reduceCost, double leastCost) {
        CouponBase couponBaseInfo = builder.build();
        CashCoupon coupon = new CashCoupon(couponBaseInfo, reduceCost);
        coupon.setLeastCost(leastCost);
        return coupon;
    }

    public static CardCoupon createDiscountCoupon(CouponBase.Builder builder, int discount) {
        CouponBase couponBaseInfo = builder.build();
        DiscountCoupon coupon = new DiscountCoupon(couponBaseInfo, discount);
        return coupon;
    }

    public static CardCoupon createGeneralCoupon(CouponBase.Builder builder, String explain) {
        CouponBase couponBaseInfo = builder.build();
        GeneralCoupon coupon = new GeneralCoupon(couponBaseInfo, explain);
        return coupon;
    }

    public static CardCoupon createGiftCoupon(CouponBase.Builder builder, String explain) {
        CouponBase couponBaseInfo = builder.build();
        GiftCoupon coupon = new GiftCoupon(couponBaseInfo, explain);
        return coupon;
    }

    public static CardCoupon createGrouponCoupon(CouponBase.Builder builder, String explain) {
        CouponBase couponBaseInfo = builder.build();
        GrouponCoupon coupon = new GrouponCoupon(couponBaseInfo, explain);
        return coupon;
    }

    public static MemberCard createMemberCard(CouponBase.Builder baseBuilder, MemberCard.Builder memberCardBudiler) {
        baseBuilder.build();
        MemberCard memberCard = new MemberCard(baseBuilder.build(), memberCardBudiler);
        return memberCard;
    }
}

