/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.cache;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.cache.AbstractCacheStorager;
import cn.ipokerface.weixin.cache.Cacheable;
import cn.ipokerface.weixin.utils.SerializationUtils;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisClusterCacheStorager<T extends Cacheable>
implements AbstractCacheStorager<T> {
    private String keys = "weixin_cache_keys";
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int SO_TIMEOUT = 5000;
    private static final int MAX_REDIRECTIONS = 5;
    private static final int MAX_TOTAL = 50;
    private static final int MAX_IDLE = 5;
    private static final int MAX_WAIT_MILLIS = 5000;
    private static final boolean TEST_ON_BORROW = false;
    private static final boolean TEST_ON_RETURN = true;
    private final JedisCluster jedisCluster;

    public RedisClusterCacheStorager(Set<HostAndPort> nodes) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(50);
        poolConfig.setMaxIdle(5);
        poolConfig.setMaxWaitMillis(5000L);
        poolConfig.setTestOnBorrow(false);
        poolConfig.setTestOnReturn(true);
        this.jedisCluster = new JedisCluster(nodes, 5000, 5000, 5, (GenericObjectPoolConfig)poolConfig);
    }

    public RedisClusterCacheStorager(Set<HostAndPort> nodes, JedisPoolConfig poolConfig) {
        this(nodes, 5000, 5000, 5, poolConfig);
    }

    public RedisClusterCacheStorager(Set<HostAndPort> nodes, int connectionTimeout, int soTimeout, int maxRedirections, JedisPoolConfig poolConfig) {
        this(new JedisCluster(nodes, connectionTimeout, soTimeout, maxRedirections, (GenericObjectPoolConfig)poolConfig));
    }

    public RedisClusterCacheStorager(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    @Override
    public T lookup(String key) {
        byte[] value = this.jedisCluster.get(key.getBytes(Constant.UTF_8));
        return (T)(value != null ? (Cacheable)SerializationUtils.deserialize(value) : null);
    }

    @Override
    public void caching(String key, T cache) {
        byte[] cacheKey = key.getBytes(Constant.UTF_8);
        byte[] value = SerializationUtils.serialize(cache);
        if (cache.expiredTime() > 0L) {
            this.jedisCluster.setex(cacheKey, (int)(cache.expiredTime() - 60000L) / 1000, value);
        } else {
            this.jedisCluster.set(cacheKey, value);
        }
        this.jedisCluster.sadd(this.keys, new String[]{key});
    }

    @Override
    public T delete(String key) {
        T cache = this.lookup(key);
        this.jedisCluster.del(key);
        this.jedisCluster.srem(this.keys, new String[]{key});
        return cache;
    }

    @Override
    public void clear() {
        Set cacheKeys = this.jedisCluster.smembers(this.keys);
        if (!cacheKeys.isEmpty()) {
            cacheKeys.add(this.keys);
            this.jedisCluster.del(cacheKeys.toArray(new String[cacheKeys.size()]));
        }
    }
}

