/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.weixin.cache;

import cn.ipokerface.weixin.cache.AbstractCacheStorager;
import cn.ipokerface.weixin.cache.Cacheable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCacheStorager<T extends Cacheable>
implements AbstractCacheStorager<T> {
    private final File tmpdir;

    public FileCacheStorager() {
        this(System.getProperty("java.io.tmpdir"));
    }

    public FileCacheStorager(String folder) {
        this.tmpdir = new File(String.format("%s%s%s", folder, File.separator, "weixin_cache_keys"));
        this.tmpdir.mkdirs();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T lookup(String key) {
        File cacheFile = new File(String.format("%s%s%s", this.tmpdir.getAbsolutePath(), File.separator, key));
        ObjectInputStream inputStream = null;
        try {
            Cacheable cache;
            if (cacheFile.exists()) {
                inputStream = new ObjectInputStream(new FileInputStream(cacheFile));
                cache = (Cacheable)inputStream.readObject();
                if (cache.createTime() < 0L) {
                    Cacheable cacheable = cache;
                    return (T)cacheable;
                }
                if (cache.createTime() + cache.expiredTime() - 60000L > System.currentTimeMillis()) {
                    Cacheable cacheable = cache;
                    return (T)cacheable;
                }
            }
            cache = null;
            return (T)cache;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void caching(String key, T cache) {
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(new File(String.format("%s%s%s", this.tmpdir.getAbsolutePath(), File.separator, key))));
            outputStream.writeObject(cache);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T delete(String key) {
        File cacheFile = new File(String.format("%s%s%s", this.tmpdir.getAbsolutePath(), File.separator, key));
        ObjectInputStream inputStream = null;
        try {
            if (cacheFile.exists()) {
                inputStream = new ObjectInputStream(new FileInputStream(cacheFile));
                Cacheable cache = (Cacheable)inputStream.readObject();
                cacheFile.delete();
                Cacheable cacheable = cache;
                return (T)cacheable;
            }
            T cache = null;
            return cache;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException(e1);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void clear() {
        for (File cache : this.tmpdir.listFiles()) {
            cache.delete();
        }
    }
}

