package cn.ipokerface.weixin.token;

import cn.ipokerface.weixin.cache.CacheCreator;
import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.Token;
import cn.ipokerface.weixin.request.WeixinRequestClient;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public abstract class TokenCreator implements CacheCreator<Token> {


    /**
     *  cache key prefix
     *
     */
    public final static String CACHEKEY_PREFIX = "weixin_";


    protected WeixinRequestClient weixinRequestClient;

    public TokenCreator(){
        this.weixinRequestClient = new WeixinRequestClient();
    }

    @Override
    public String key() {
        return null;
    }

    @Override
    public Token create() throws WeixinException {
        return null;
    }

    /**
     * 返回缓存类型命名，如mp_token
     *
     * @return
     */
    public abstract String name();

    /**
     * 返回缓存唯一标识，如appid
     *
     * @return
     */
    public abstract String uniqueid();
}
