package cn.ipokerface.weixin.token;

import cn.ipokerface.weixin.cache.AbstractCacheStorager;
import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.Token;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class TicketManager {


    /**
     * 第三方ID
     */
    private final String thirdId;
    /**
     * 第三方secret
     */
    private final String thirdSecret;


    /**
     * ticket存储策略
     */
    private final AbstractCacheStorager<Token> cacheStorager;

    /**
     *
     * @param thirdId
     *            第三方ID suiteId/componentId
     * @param thirdSecret
     *            第三方secret
     * @param cacheStorager
     *            ticket存储策略
     */
    public TicketManager(String thirdId, String thirdSecret,
                         AbstractCacheStorager<Token> cacheStorager) {
        this.thirdId = thirdId;
        this.thirdSecret = thirdSecret;
        this.cacheStorager = cacheStorager;
    }

    /**
     * 获取ticket对象
     *
     * @return token对象
     * @throws WeixinException
     */
    public Token getTicket() throws WeixinException {
        return cacheStorager.lookup(getCacheKey());
    }

    /**
     * 获取ticket
     *
     * @return ticket
     * @throws WeixinException
     */
    public String getAccessTicket() throws WeixinException {
        return getTicket().getAccessToken();
    }

    /**
     * 获取ticket的key
     *
     * @return
     */
    public String getCacheKey() {
        return String.format("%sthird_party_ticket_%s",
                TokenCreator.CACHEKEY_PREFIX, thirdId);
    }

    /**
     * 缓存ticket
     *
     * @param ticket
     *            票据凭证
     * @throws WeixinException
     */
    public void cachingTicket(String ticket) throws WeixinException {
        Token token = new Token(ticket);
        cacheStorager.caching(getCacheKey(), token);
    }

    public String getThirdId() {
        return thirdId;
    }

    public String getThirdSecret() {
        return thirdSecret;
    }

    public AbstractCacheStorager<Token> getCacheStorager() {
        return cacheStorager;
    }
}
