package cn.ipokerface.weixin.sign;

import cn.ipokerface.weixin.utils.MapUtils;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public abstract class AbstractWeixinSignature implements WeixinSignature {

    /**
     * 是否编码
     *
     * @return 默认false不进行编码
     */
    @Override
    public boolean encoder() {
        return false;
    }

    /**
     * 是否转换小写
     *
     * @return 默认false不转换小写
     */
    @Override
    public boolean lowerCase() {
        return false;
    }

    /**
     * 拼接字符串
     *
     * @param obj
     * @return
     */
    protected StringBuilder join(Object obj) {
        return new StringBuilder(MapUtils.toJoinString(obj, encoder(),
                lowerCase()));
    }
}
