package cn.ipokerface.weixin.request.http.message;

import cn.ipokerface.weixin.request.http.HttpHeaders;
import cn.ipokerface.weixin.request.http.HttpResponse;
import cn.ipokerface.weixin.request.http.MimeType;
import cn.ipokerface.weixin.utils.FileUtils;
import cn.ipokerface.weixin.utils.RegexUtil;
import cn.ipokerface.weixin.xml.XmlFormatter;

import java.io.IOException;
import java.io.InputStream;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class XmlMessageConverter extends AbstractMessageConverter {

    public static final XmlMessageConverter GLOBAL = new XmlMessageConverter();

    private static final String XML = "xml";
    private static final int BRACKET = '<';

    public XmlMessageConverter() {
        super(MimeType.APPLICATION_XML, MimeType.TEXT_XML, new MimeType("application", "*+xml"));
    }

    @Override
    public boolean canConvert(Class<?> clazz, HttpResponse response) {
        if (!super.canConvert(clazz, response)) {
            String disposition = response.getHeaders().getFirst(HttpHeaders.CONTENT_DISPOSITION);
            String fileName = RegexUtil.regexFileNameFromContentDispositionHeader(disposition);
            return (fileName != null && FileUtils.getFileExtension(fileName).equalsIgnoreCase(XML));
        }
        return true;
    }

    @Override
    protected boolean supports(Class<?> clazz, byte[] content) {
        return BRACKET == content[0];
    }

    @Override
    protected <T> T convertInternal(Class<? extends T> clazz, InputStream body) throws IOException {
        return XmlFormatter.fromXML(body, clazz);
    }
}
