package cn.ipokerface.weixin.request.http.entity;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.request.http.ContentType;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class StringEntity implements HttpEntity {

    private final byte[]      content;
    private final ContentType contentType;

    public StringEntity(String body) {
        this(body, ContentType.DEFAULT_TEXT);
    }

    public StringEntity(String body, ContentType contentType) {
        this.content = body.getBytes(contentType.getCharset());
        this.contentType = contentType;
    }

    @Override
    public ContentType getContentType() {
        return contentType;
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    @Override
    public void writeTo(OutputStream outstream) throws IOException {
        outstream.write(this.content);
        outstream.flush();
    }


    public String getContentString() {
        return new String(this.content, Constant.UTF_8);
    }

}
