package cn.ipokerface.weixin.request.http.entity;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.request.http.ContentType;
import cn.ipokerface.weixin.request.http.URLParameter;
import cn.ipokerface.weixin.utils.URLEncodingUtil;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class FormUrlEntity extends StringEntity {

    private static final String PARAMETER_SEPARATOR = "&";

    public FormUrlEntity(List<URLParameter> parameters) {
        super(formatParameters(parameters),
                ContentType.APPLICATION_FORM_URLENCODED);
    }

    public FormUrlEntity(Map<String, String> parameters) {
        super(formatParameters(parameters),
                ContentType.APPLICATION_FORM_URLENCODED);
    }

    public static String formatParameters(List<URLParameter> parameters) {
        StringBuilder body = new StringBuilder();
        URLParameter parameter = parameters.get(0);
        body.append(parameter.encoding());
        for (int i = 1; i < parameters.size(); i++) {
            body.append(PARAMETER_SEPARATOR);
            parameter = parameters.get(i);
            body.append(parameter.encoding());
        }
        return body.toString();
    }

    public static String formatParameters(Map<String, String> parameters) {
        StringBuilder body = new StringBuilder();
        Iterator<Map.Entry<String, String>> it = parameters.entrySet().iterator();
        it.hasNext();
        Map.Entry<String, String> parameter = it.next();
        body.append(String.format("%s=%s", URLEncodingUtil.encoding(
                parameter.getKey(), Constant.UTF_8, true), URLEncodingUtil
                .encoding(parameter.getValue(), Constant.UTF_8, true)));
        while (it.hasNext()) {
            parameter = it.next();
            body.append(PARAMETER_SEPARATOR).append(
                    String.format("%s=%s", URLEncodingUtil.encoding(
                            parameter.getKey(), Constant.UTF_8, true),
                            URLEncodingUtil.encoding(parameter.getValue(),
                                    Constant.UTF_8, true)));
        }
        return body.toString();
    }
}

