package cn.ipokerface.weixin.request.http.apache;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.request.http.ContentType;

import java.io.*;
import java.nio.charset.Charset;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class StringBody extends AbstractContentBody {

    private final byte[] content;

    /**
     * @since 4.1
     *
     * @deprecated (4.3) use {@link StringBody#StringBody(String, ContentType)}
     *   or
     */
    @Deprecated
    public static StringBody create(
            final String text,
            final String mimeType,
            final Charset charset) throws IllegalArgumentException {
        try {
            return new StringBody(text, mimeType, charset);
        } catch (final UnsupportedEncodingException ex) {
            throw new IllegalArgumentException("Charset " + charset + " is not supported", ex);
        }
    }

    /**
     * @since 4.1
     *
     * @deprecated (4.3) use {@link StringBody#StringBody(String, ContentType)}
     *
     */
    @Deprecated
    public static StringBody create(
            final String text, final Charset charset) throws IllegalArgumentException {
        return create(text, null, charset);
    }

    /**
     * @since 4.1
     *
     * @deprecated (4.3) use {@link StringBody#StringBody(String, ContentType)}
     *   or
     */
    @Deprecated
    public static StringBody create(final String text) throws IllegalArgumentException {
        return create(text, null, null);
    }

    /**
     * Create a StringBody from the specified text, MIME type and character set.
     *
     * @param text to be used for the body, not {@code null}
     * @param mimeType the MIME type, not {@code null}
     * @param charset the character set, may be {@code null}, in which case the US-ASCII charset is used
     * @throws UnsupportedEncodingException
     * @throws IllegalArgumentException if the {@code text} parameter is null
     *
     */
    public StringBody(
            final String text,
            final String mimeType,
            final Charset charset) throws UnsupportedEncodingException {
        this(text, ContentType.create(mimeType, charset != null ? charset : Constant.UTF_8));
    }

    /**
     * Create a StringBody from the specified text and character set.
     * The MIME type is set to "text/plain".
     *
     * @param text to be used for the body, not {@code null}
     * @param charset the character set, may be {@code null}, in which case the US-ASCII charset is used
     * @throws UnsupportedEncodingException
     * @throws IllegalArgumentException if the {@code text} parameter is null
     *
     */
    public StringBody(final String text, final Charset charset) throws UnsupportedEncodingException {
        this(text, "text/plain", charset);
    }

    /**
     * Create a StringBody from the specified text.
     * The MIME type is set to "text/plain".
     * The  Constant# ASCII charset is used.
     *
     * @param text to be used for the body, not {@code null}
     * @throws UnsupportedEncodingException
     * @throws IllegalArgumentException if the {@code text} parameter is null
     *
     */
    public StringBody(final String text) throws UnsupportedEncodingException {
        this(text, "text/plain", Constant.UTF_8);
    }

    /**
     * @since 4.3
     */
    public StringBody(final String text, final ContentType contentType) {
        super(contentType);
        final Charset charset = contentType.getCharset();
        this.content = text.getBytes(charset != null ? charset : Constant.UTF_8);
    }

    public Reader getReader() {
        final Charset charset = getContentType().getCharset();
        return new InputStreamReader(
                new ByteArrayInputStream(this.content),
                charset != null ? charset : Constant.UTF_8);
    }

    @Override
    public void writeTo(final OutputStream out) throws IOException {
        final InputStream in = new ByteArrayInputStream(this.content);
        final byte[] tmp = new byte[4096];
        int l;
        while ((l = in.read(tmp)) != -1) {
            out.write(tmp, 0, l);
        }
        out.flush();
    }

    @Override
    public String getTransferEncoding() {
        return Mime.ENC_8BIT;
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public String getFilename() {
        return null;
    }
}
