package cn.ipokerface.weixin.request.http.apache;

import cn.ipokerface.weixin.request.http.ContentType;
import cn.ipokerface.weixin.request.http.entity.HttpEntity;

import java.io.*;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class MultipartFormEntity implements HttpEntity {

    private final AbstractMultipartForm multipart;
    private final ContentType contentType;
    private final long contentLength;

    MultipartFormEntity(final AbstractMultipartForm multipart,
                        final ContentType contentType, final long contentLength) {
        super();
        this.multipart = multipart;
        this.contentType = contentType;
        this.contentLength = contentLength;
    }

    AbstractMultipartForm getMultipart() {
        return this.multipart;
    }

    public boolean isRepeatable() {
        return this.contentLength != -1;
    }

    public boolean isChunked() {
        return !isRepeatable();
    }

    public boolean isStreaming() {
        return !isRepeatable();
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public InputStream getContent() throws IOException {
        if (this.contentLength < 0) {
            throw new IllegalArgumentException("Content length is unknown");
        } else if (this.contentLength > 5 * 1024 * 1024) {
            throw new IllegalArgumentException("Content length is too long: "
                    + this.contentLength);
        }
        final ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        writeTo(outstream);
        outstream.flush();
        return new ByteArrayInputStream(outstream.toByteArray());
    }

    @Override
    public void writeTo(final OutputStream outstream) throws IOException {
        this.multipart.writeTo(outstream);
    }
}