package cn.ipokerface.weixin.request.http.apache;

import cn.ipokerface.weixin.request.http.MimeType;

import java.io.IOException;
import java.io.OutputStream;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public interface ContentBody {

    /**
     * Returns the body descriptors MIME type.
     *
     * @return The MIME type, which has been parsed from the content-type
     *         definition. Must not be null, but "text/plain", if no
     *         content-type was specified.
     */
    MimeType getMimeType();

    /**
     * <p>
     * The body descriptors character set, defaulted appropriately for the MIME
     * type.
     * </p>
     * <p>
     * For {@code TEXT} types, this will be defaulted to {@code us-ascii}. For
     * other types, when the charset parameter is missing this property will be
     * null.
     * </p>
     *
     * @return Character set, which has been parsed from the content-type
     *         definition. Not null for {@code TEXT} types, when unset will be
     *         set to default {@code us-ascii}. For other types, when unset,
     *         null will be returned.
     */
    String getCharset();

    /**
     * Returns the body descriptors transfer encoding.
     *
     * @return The transfer encoding. Must not be null, but "7bit", if no
     *         transfer-encoding was specified.
     */
    String getTransferEncoding();

    /**
     * Returns the body descriptors content-length.
     *
     * @return Content length, if known, or -1, to indicate the absence of a
     *         content-length header.
     */
    long getContentLength();

    String getFilename();

    void writeTo(OutputStream out) throws IOException;
}
