package cn.ipokerface.weixin.request.http.apache;

import cn.ipokerface.weixin.request.http.ContentType;
import cn.ipokerface.weixin.request.http.MimeType;

import java.nio.charset.Charset;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public abstract class AbstractContentBody implements ContentBody {

    private final ContentType contentType;

    /**
     * @since 4.3
     */
    public AbstractContentBody(final ContentType contentType) {
        super();
        this.contentType = contentType;
    }

    /**
     * @since 4.3
     */
    public ContentType getContentType() {
        return this.contentType;
    }

    @Override
    public MimeType getMimeType() {
        return this.contentType.getMimeType();
    }

    @Override
    public String getCharset() {
        final Charset charset = this.contentType.getCharset();
        return charset != null ? charset.name() : null;
    }
}