package cn.ipokerface.weixin.request.http;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.utils.URLEncodingUtil;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class URLParameter extends NameValue {

    private static final long serialVersionUID = -115491642760990655L;

    public URLParameter(String name, String value) {
        super(name, value);
    }

    public String encoding() {
        return String.format("%s=%s",
                URLEncodingUtil.encoding(getName(), Constant.UTF_8, true),
                URLEncodingUtil.encoding(getValue(), Constant.UTF_8, true));
    }

    @Override
    public String toString() {
        return String.format("[URLParameter name=%s, value=%s]", getName(),
                getValue());
    }
}