package cn.ipokerface.weixin.request.http;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import java.net.Proxy;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class HttpParams {
    /**
     * 连接超时时间(单位毫秒)
     */
    private int connectTimeout;
    /**
     * 读取超时时间(单位毫秒)
     */
    private int readTimeout;
    /**
     * 代理对象
     */
    private Proxy proxy;
    /**
     * SSL对象
     */
    private SSLContext sslContext;
    /**
     * hostname对象
     */
    private HostnameVerifier hostnameVerifier;

    /**
     * connectTimeout = 15000,readTimeout=20000
     */
    public HttpParams() {
        this(5000, 15000);
    }

    public HttpParams(int connectTimeout, int readTimeout) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    public int getReadTimeout() {
        return readTimeout;
    }

    public Proxy getProxy() {
        return proxy;
    }

    public HttpParams setProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public SSLContext getSSLContext() {
        return sslContext;
    }

    public HttpParams setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public HostnameVerifier getHostnameVerifier() {
        return hostnameVerifier;
    }

    public HttpParams setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public static HttpParams copy(final HttpParams params) {
        return new HttpParams(params.getConnectTimeout(),
                params.getReadTimeout()).setProxy(params.getProxy())
                .setHostnameVerifier(params.getHostnameVerifier())
                .setSSLContext(params.getSSLContext());
    }

    @Override
    public String toString() {
        return "HttpParams [connectTimeout=" + connectTimeout
                + ", readTimeout=" + readTimeout + ", proxy=" + proxy
                + ", sslContext=" + sslContext + ", hostnameVerifier="
                + hostnameVerifier + "]";
    }
}