package cn.ipokerface.weixin.request.http;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public abstract class AbstractHttpResponse implements HttpResponse {
    protected final static String KEEP_ALIVE = "keep-alive";
    private final byte[] content;

    public AbstractHttpResponse(byte[] content) {
        this.content = content;
    }


    public byte[] getContent() {
        return content;
    }


    public InputStream getBody() {
        return content != null ? new ByteArrayInputStream(content) : null;
    }
}

