package cn.ipokerface.weixin.request.http;

import cn.ipokerface.weixin.request.http.entity.FormUrlEntity;
import cn.ipokerface.weixin.request.http.entity.HttpEntity;


import java.util.Arrays;
import java.util.Set;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public abstract class AbstractHttpClient implements HttpClient {


    public HttpResponse get(String url) throws HttpClientException {
        return execute(HttpMethod.GET, url);
    }


    public HttpResponse get(String url, URLParameter... parameters)
            throws HttpClientException {
        return execute(HttpMethod.GET, url, parameters);
    }

    public HttpHeaders head(String url) throws HttpClientException {
        return head(url, (URLParameter[]) null);
    }

    public HttpHeaders head(String url, URLParameter... parameters)
            throws HttpClientException {
        return execute(HttpMethod.HEAD, url, parameters).getHeaders();
    }

    public HttpResponse post(String url) throws HttpClientException {
        return execute(HttpMethod.POST, url);
    }

    public HttpResponse post(String url, URLParameter... parameters)
            throws HttpClientException {
        HttpEntity entity = null;
        if (parameters != null && parameters.length > 0) {
            entity = new FormUrlEntity(Arrays.asList(parameters));
        }
        return post(url, entity);
    }

    public HttpResponse post(String url, HttpEntity entity)
            throws HttpClientException {
        HttpRequest request = new HttpRequest(HttpMethod.POST, url);
        request.setEntity(entity);
        return execute(request);
    }

    public void put(String url) throws HttpClientException {
        execute(HttpMethod.PUT, url);
    }

    public void put(String url, URLParameter... parameters)
            throws HttpClientException {
        execute(HttpMethod.PUT, url, parameters);
    }

    public void delete(String url) throws HttpClientException {
        execute(HttpMethod.DELETE, url);
    }

    public void delete(String url, URLParameter... parameters)
            throws HttpClientException {
        execute(HttpMethod.DELETE, url, parameters);
    }

    public Set<HttpMethod> options(String url) throws HttpClientException {
        return options(url, (URLParameter[]) null);
    }



    public Set<HttpMethod> options(String url, URLParameter... parameters)
            throws HttpClientException {
        HttpHeaders headers = execute(HttpMethod.OPTIONS, url, parameters)
                .getHeaders();
        return headers.getAllow();
    }

    protected HttpResponse execute(HttpMethod method, String url)
            throws HttpClientException {
        return execute(new HttpRequest(method, url));
    }

    protected HttpResponse execute(HttpMethod method, String url,
                                   URLParameter... parameters) throws HttpClientException {
        StringBuilder buf = new StringBuilder(url);
        if (parameters != null && parameters.length > 0) {
            if (url.indexOf("?") < 0) {
                buf.append("?");
            } else {
                buf.append("&");
            }
            buf.append(FormUrlEntity.formatParameters(Arrays.asList(parameters)));
        }
        return execute(new HttpRequest(method, buf.toString()));
    }

    protected boolean hasError(HttpStatus status) {
        return (status.series() == HttpStatus.Series.CLIENT_ERROR || status
                .series() == HttpStatus.Series.SERVER_ERROR);
    }

    protected void handleResponse(HttpResponse response)
            throws HttpClientException {
        HttpStatus status = response.getStatus();
        HttpHeaders headers = response.getHeaders();
        MimeType resultType = MimeType.valueOf(headers
                .getFirst(HttpHeaders.CONTENT_TYPE));
        if (!MimeType.APPLICATION_JSON.includes(resultType) && hasError(status)) {
            switch (status.series()) {
                case CLIENT_ERROR:
                case SERVER_ERROR:
                    throw new HttpClientException(String.format("%d %s",
                            status.getStatusCode(), status.getStatusText()));
                default:
                    throw new HttpClientException("Unknown status code [" + status
                            + "]");
            }
        }
    }
}
