package cn.ipokerface.weixin.request;

import cn.ipokerface.weixin.request.http.HttpHeaders;
import cn.ipokerface.weixin.request.http.HttpResponse;
import cn.ipokerface.weixin.request.http.HttpStatus;
import cn.ipokerface.weixin.request.http.HttpVersion;
import cn.ipokerface.weixin.request.http.message.JsonMessageConverter;
import cn.ipokerface.weixin.request.http.message.MessageConverter;
import cn.ipokerface.weixin.request.http.message.XmlMessageConverter;
import cn.ipokerface.weixin.utils.StringUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class WeixinResponse implements HttpResponse {

    private volatile String text;
    private final HttpResponse response;
    private static List<MessageConverter> messageConverters = new ArrayList<MessageConverter>();
    private final TypeReference<ApiResult> APIRESULT_CLAZZ = new TypeReference<ApiResult>() {
    };
    private final TypeReference<ApiXmlResult> XMLRESULT_CLAZZ = new TypeReference<ApiXmlResult>() {
    };
    private final TypeReference<JSONObject> JSONOBJECT_CLAZZ = new TypeReference<JSONObject>() {
    };

    static {
        messageConverters.add(new JsonMessageConverter());
        messageConverters.add(new XmlMessageConverter());
    }

    public WeixinResponse(HttpResponse response) {
        this.response = response;
    }

    public String getAsString() {
        if (text == null) {
            text = StringUtil.newStringUtf8(getContent());
        }
        return text;
    }

    public ApiResult getAsResult() {
        return getAsObject(APIRESULT_CLAZZ);
    }

    public JSONObject getAsJson() {
        return getAsObject(JSONOBJECT_CLAZZ);
    }

    public ApiXmlResult getAsXml() {
        return getAsObject(XMLRESULT_CLAZZ);
    }

    @SuppressWarnings("unchecked")
    public <T> T getAsObject(TypeReference<T> typeReference) {
        Class<T> clazz = (Class<T>) typeReference.getType();
        for (MessageConverter messageConverter : messageConverters) {
            if (messageConverter.canConvert(clazz, response)) {
                try {
                    return messageConverter.convert(clazz, response);
                } catch (IOException e) {
                    throw new RuntimeException("IO error on convert to "
                            + clazz, e);
                }
            }
        }
        if (clazz.isAssignableFrom(ApiResult.class)) {
            return (T) new ApiResult();
        }
        throw new RuntimeException("cannot convert to " + clazz);
    }

    @Override
    public HttpHeaders getHeaders() {
        return response.getHeaders();
    }

    @Override
    public HttpStatus getStatus() {
        return response.getStatus();
    }

    @Override
    public byte[] getContent() {
        return response.getContent();
    }

    @Override
    public InputStream getBody() {
        return response.getBody();
    }

    @Override
    public HttpVersion getProtocol() {
        return response.getProtocol();
    }

    @Override
    public void close() {
        response.close();
    }
}
