package cn.ipokerface.weixin.proxy.redpack;

import cn.ipokerface.weixin.Constant;
import cn.ipokerface.weixin.utils.DateUtils;
import cn.ipokerface.weixin.utils.MapUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class RedPacketRisk {


    private Map<String, String> risk;

    public RedPacketRisk() {
        this.risk = new HashMap<String, String>();
    }

    /**
     * 用户操作的时间戳
     *
     * @return
     */
    public RedPacketRisk postTimestamp() {
        risk.put("posttime", DateUtils.timestamp2string());
        return this;
    }

    /**
     * 业务系统账号的手机号，国家代码-手机号。不需要+号
     *
     * @param mobile
     * @return
     */
    public RedPacketRisk mobile(String mobile) {
        risk.put("mobile", mobile);
        return this;
    }

    /**
     * 用户操作的客户端版本
     *
     * @param clientVersion
     * @return
     */
    public RedPacketRisk clientVersion(String clientVersion) {
        risk.put("clientversion", clientVersion);
        return this;
    }

    /**
     * mac 地址或者设备唯一标识
     *
     * @param deviceid
     * @return
     */
    public RedPacketRisk deviceid(String deviceid) {
        risk.put("deviceid", deviceid);
        return this;
    }

    public Map<String, String> getRisk() {
        return risk;
    }

    public String toContent() {
        if (risk.isEmpty())
            return null;
        try {
            return URLEncoder.encode(MapUtils.toJoinString(risk, false, false),
                    Constant.UTF_8.name());
        } catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}