package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.utils.DateUtils;
import cn.ipokerface.weixin.utils.RandomUtil;
import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.*;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class PaymentRequest extends PaymentBase {

    private static final long serialVersionUID = -453746488398523883L;

    /**
     * 订单详情扩展 订单信息组成该字符串
     */
    @XmlElement(name = "Package")
    @JSONField(name = "package")
    private String packageInfo;

    /**
     * 冗余字段
     */
    @XmlTransient
    @JSONField(serialize = false)
    private String prepayId;
    /**
     * 冗余字段
     */
    @XmlTransient
    @JSONField(serialize = false)
    private String partnerId;


    protected PaymentRequest() {
        // jaxb required
    }

    public PaymentRequest(String appId, String packageInfo) {
        super(appId, DateUtils.timestamp2string(), RandomUtil.generateString(16));
        this.packageInfo = packageInfo;
    }

    public String getPackageInfo() {
        return packageInfo;
    }

    public void setPackageInfo(String packageInfo) {
        this.packageInfo = packageInfo;
    }

    public String getPrepayId() {
        return prepayId;
    }

    public void setPrepayId(String prepayId) {
        this.prepayId = prepayId;
    }

    public String getPartnerId() {
        return partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }


    @Override
    public String toString() {
        return "package" + packageInfo + ", prepayId=" + prepayId
                + super.toString();
    }
}