package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.sign.SignType;
import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.*;
import java.io.Serializable;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */

@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class PaymentBase implements Serializable {

    private static final long serialVersionUID = 1843024880782466990L;

    /**
     * 公众号ID
     */
    @JSONField(name = "appId")
    @XmlElement(name = "AppId")
    private String appId;
    /**
     * 时间戳
     */
    @JSONField(name = "timeStamp")
    @XmlElement(name = "TimeStamp")
    private String timeStamp;
    /**
     * 随机字符串
     */
    @JSONField(name = "nonceStr")
    @XmlElement(name = "NonceStr")
    private String nonceStr;
    /**
     * 签名结果
     */
    @JSONField(name = "paySign")
    @XmlElement(name = "AppSignature")
    private String paySign;
    /**
     * 签名方式
     */
    @JSONField(name = "signType")
    @XmlElement(name = "SignMethod")
    private String signType;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getTimeStamp() {
        return timeStamp;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getPaySign() {
        return paySign;
    }

    public void setPaySign(String paySign) {
        this.paySign = paySign;
    }

    public String getSignType() {
        return signType;
    }

    @XmlTransient
    @JSONField(serialize = false)
    public SignType getFormatSignType() {
        return signType != null ? SignType.valueOf(signType.toUpperCase())
                : null;
    }

    public void setSignType(SignType signType) {
        this.signType = signType != null ? signType.name() : null;
    }

    public PaymentBase() {
    }

    public PaymentBase(String appId, String timestamp, String noncestr) {
        this.appId = appId;
        this.timeStamp = timestamp;
        this.nonceStr = noncestr;
    }

    @Override
    public String toString() {
        return "appId=" + appId + ", timeStamp=" + timeStamp + ", nonceStr="
                + nonceStr + ", paySign=" + paySign + ", signType=" + signType;
    }
}