package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.payment.TradeType;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class NativePaymentRequest extends AbstractPaymentRequest {

    private final String codeUrl;

	public NativePaymentRequest(String prePayId, String codeUrl,
            WeixinPayAccount payAccount) {
        super(prePayId, payAccount);
        this.codeUrl = codeUrl;
    }

    @Override
    public TradeType getPaymentType() {
        return TradeType.NATIVE;
    }

    /**
     * <font color="red">只做查看之用,请不要尝试作为支付请求</font>
     */
    @Override
    public PaymentRequest toRequestObject() {
        return new PaymentRequest(getPaymentAccount().getId(), "code_url=" + codeUrl);
    }

    @Override
    public String toRequestString() {
        return this.codeUrl;
    }
}
