package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.payment.TradeType;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public interface MerchantPaymentRequest {
    /**
     * 预支付交易ID
     *
     * @return
     */
    public String getPrePayId();

    /**
     * 支付账号
     *
     * @return
     */
    public WeixinPayAccount getPaymentAccount();

    /**
     * 支付类型
     *
     * @return
     */
    public TradeType getPaymentType();

    /**
     * 支付请求字符串
     *
     * @return
     */
    public String toRequestString();

    /**
     * 支付请求对象
     *
     * @return
     */
    public PaymentRequest toRequestObject();
}
