package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.payment.TradeType;
import cn.ipokerface.weixin.sign.SignType;
import com.alibaba.fastjson.JSON;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class JsapiPaymentRequest extends AbstractPaymentRequest {

    public JsapiPaymentRequest(String prePayId, WeixinPayAccount payAccount) {
        super(prePayId, payAccount);
    }

    @Override
    public TradeType getPaymentType() {
        return TradeType.JSAPI;
    }

    @Override
    public PaymentRequest toRequestObject() {
        PaymentRequest payRequest = new PaymentRequest(getPaymentAccount().getId(),
                "prepay_id=" + getPrePayId());
        payRequest.setSignType(SignType.MD5);
        payRequest.setPaySign(weixinSignature.sign(payRequest));
        return payRequest;
    }

    @Override
    public String toRequestString() {
        return JSON.toJSONString(toRequestObject());
    }
}