package cn.ipokerface.weixin.proxy.payment;

import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.sign.WeixinPaymentSignature;
import cn.ipokerface.weixin.sign.WeixinSignature;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public abstract class AbstractPaymentRequest implements MerchantPaymentRequest {

    private final String prePayId;
    private final WeixinPayAccount paymentAccount;
    protected final WeixinSignature weixinSignature;

    public AbstractPaymentRequest(String prePayId, WeixinPayAccount paymentAccount) {
        this.prePayId = prePayId;
        this.paymentAccount = paymentAccount;
        this.weixinSignature = new WeixinPaymentSignature(paymentAccount.getPaySignKey());
    }

    @Override
    public String getPrePayId() {
        return this.prePayId;
    }

    @Override
    public WeixinPayAccount getPaymentAccount() {
        return this.paymentAccount;
    }
}