package cn.ipokerface.weixin.proxy.coupon;

import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class RefundCoupon implements Serializable {

    private static final long serialVersionUID = -8744999305258786901L;

    /**
     * 代金券或立减优惠批次ID
     */
    @XmlElement(name = "coupon_refund_batch_id")
    @JSONField(name = "coupon_refund_batch_id")
    private String couponBatchId;
    /**
     * 退款代金券ID
     */
    @XmlElement(name = "coupon_refund_id")
    @JSONField(name = "coupon_refund_id")
    private String couponId;
    /**
     * 单个代金券或立减优惠支付金额
     */
    @XmlElement(name = "coupon_refund_fee")
    @JSONField(name = "coupon_refund_fee")
    private Integer couponFee;

    protected RefundCoupon() {
        // jaxb requried
    }

    public String getCouponBatchId() {
        return couponBatchId;
    }

    public String getCouponId() {
        return couponId;
    }

    public Integer getCouponFee() {
        return couponFee;
    }

    /**
     * <font color="red">调用接口获取单位为分,get方法转换为元方便使用</font>
     *
     * @return 元单位
     */
    @JSONField(serialize = false)
    public double getFormatCouponFee() {
        return couponFee != null ? couponFee.doubleValue() / 100d : 0d;
    }

    @Override
    public String toString() {
        return "couponBatchId=" + couponBatchId + ", couponId=" + couponId
                + ", couponFee=" + couponFee;
    }
}