package cn.ipokerface.weixin.proxy.company;

import cn.ipokerface.weixin.proxy.merchant.MerchantResult;
import cn.ipokerface.weixin.utils.DateUtils;
import com.alibaba.fastjson.annotation.JSONField;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Date;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@XmlRootElement
@XmlAccessorType(XmlAccessType.FIELD)
public class CompanyPaymentResult extends MerchantResult {

    private static final long serialVersionUID = 1110472826089211646L;

    /**
     * 微信订单订单号
     */
    @JSONField(name = "payment_no")
    @XmlElement(name = "payment_no")
    private String transactionId;
    /**
     * 商户订单号
     */
    @JSONField(name = "partner_trade_no")
    @XmlElement(name = "partner_trade_no")
    private String outTradeNo;
    /**
     * 支付时间
     */
    @JSONField(name = "payment_time")
    @XmlElement(name = "payment_time")
    private String paymentTime;

    protected CompanyPaymentResult() {
        // jaxb required
    }

    public String getTransactionId() {
        return transactionId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public String getPaymentTime() {
        return paymentTime;
    }

    @JSONField(serialize = false)
    public Date getFormatPaymentTime() {
        return paymentTime != null ? DateUtils.parseDate(paymentTime,
                "yyyy-MM-dd HH:mm:ss") : null;
    }

    @Override
    public String toString() {
        return "CorpPaymentResult [transactionId=" + transactionId
                + ", outTradeNo=" + outTradeNo + ", paymentTime=" + paymentTime
                + ", " + super.toString() + "]";
    }
}