package cn.ipokerface.weixin.proxy;

import cn.ipokerface.weixin.exception.WeixinException;
import cn.ipokerface.weixin.model.WeixinPayAccount;
import cn.ipokerface.weixin.model.custom.CustomCity;
import cn.ipokerface.weixin.proxy.merchant.IdQuery;
import cn.ipokerface.weixin.proxy.order.CustomOrder;
import cn.ipokerface.weixin.proxy.order.CustomOrderRecord;
import cn.ipokerface.weixin.proxy.order.CustomOrderResult;
import cn.ipokerface.weixin.request.WeixinApis;
import cn.ipokerface.weixin.request.WeixinResponse;
import cn.ipokerface.weixin.xml.ListSuffixResultDeserializer;
import cn.ipokerface.weixin.xml.XmlFormatter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class OrderProxy extends MerchantProxy {

    public OrderProxy(WeixinPayAccount weixinAccount) {
        super(weixinAccount);
    }


    /**
     * 订单附加信息提交
     *
     * @param customsOrder
     *            附加订单信息
     * @return 报关结果
     * @see cn.ipokerface.weixin.proxy.order.CustomOrder

     * @see <a
     *      href="https://pay.weixin.qq.com/wiki/doc/api/external/declarecustom.php?chapter=18_1">附加订单信息提交接口</a>
     * @throws WeixinException
     */
    public CustomOrderResult declareCustomsOrder(CustomOrder customsOrder)
            throws WeixinException {
        JSONObject para = (JSONObject) JSON.toJSON(customsOrder);
        para.put("appid", weixinPayAccount.getId());
        para.put("mch_id", weixinPayAccount.getMchId());
        para.put("sign", weixinSignature.sign(para));
        String param = XmlFormatter.map2xml(para);
        WeixinResponse response = weixinRequestClient.post(
                WeixinApis.customs_order_declare_uri, param);
        return response.getAsObject(new TypeReference<CustomOrderResult>() {
        });
    }



    /**
     * 订单附加信息查询
     *
     * @param idQuery
     *            out_trade_no,transaction_id,sub_order_no,sub_order_id四选一
     * @param customsCity
     *            海关
     * @return 报关记录
     * @see cn.ipokerface.weixin.proxy.order.CustomOrderRecord
     * @see <a
     *      href="https://pay.weixin.qq.com/wiki/doc/api/external/declarecustom.php?chapter=18_1">附加订单信息查询接口</a>
     * @throws WeixinException
     */
    public CustomOrderRecord queryCustomsOrder(IdQuery idQuery,
                                               CustomCity customsCity) throws WeixinException {
        JSONObject para = new JSONObject();
        para.put("appid", weixinPayAccount.getId());
        para.put("mch_id", weixinPayAccount.getMchId());
        para.put(idQuery.getType().getName(), idQuery.getId());
        para.put("customs", customsCity.name());
        para.put("sign", weixinSignature.sign(para));
        String param = XmlFormatter.map2xml(para);
        WeixinResponse response = weixinRequestClient.post(
                WeixinApis.customs_order_query_uri, param);
        return ListSuffixResultDeserializer.deserialize(response.getAsString(),
                CustomOrderRecord.class);
    }

}
