package cn.ipokerface.weixin.model.media;

import cn.ipokerface.weixin.model.page.PageData;
import cn.ipokerface.weixin.model.page.Pageable;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class MediaRecord implements Serializable {

    private static final long serialVersionUID = 7017503153256241457L;

    /**
     * 该类型的素材的总数
     */
    @JSONField(name = "total_count")
    private int totalCount;
    /**
     * 本次调用获取的素材的数量
     */
    @JSONField(name = "item_count")
    private int itemCount;
    /**
     * 媒体类型
     */
    @JSONField(serialize = false, deserialize = false)
    private MediaType mediaType;
    /**
     * 媒体信息
     */
    @JSONField(name = "items")
    private List<MediaItem> items;
    /**
     * 分页信息
     */
    @JSONField(serialize = false, deserialize = false)
    private Pageable pageable;
    @JSONField(serialize = false, deserialize = false)
    private volatile PageData<MediaItem> pagedata;

    public int getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getItemCount() {
        return itemCount;
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
    }

    public MediaType getMediaType() {
        return mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public List<MediaItem> getItems() {
        return items;
    }

    public void setItems(List<MediaItem> items) {
        this.items = items;
    }

    public Pageable getPageable() {
        return pageable;
    }

    public void setPageable(Pageable pageable) {
        this.pageable = pageable;
    }

    public PageData<MediaItem> getPagedata() {
        if (pagedata == null) {
            pagedata = new PageData<MediaItem>(pageable, totalCount, items);
        }
        return pagedata;
    }

    @Override
    public String toString() {
        return "MediaRecord [totalCount=" + totalCount + ", itemCount="
                + itemCount + ", mediaType=" + mediaType + ", items=" + items
                + ", pageable=" + pageable + "]";
    }
}