package cn.ipokerface.weixin.model.card;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class GrouponCoupon extends CardCoupon {
    /**
     * 团购详情
     */
    @JSONField(name = "deal_detail")
    private final String explain;

    /**
     * 构造团购券
     *
     * @param couponBaseInfo
     *            基础信息
     * @param explain
     *            团购详情 如：双人套餐\n -进口红酒一支。\n孜然牛肉一份。
     */
    public GrouponCoupon(CouponBase couponBaseInfo, String explain) {
        super(couponBaseInfo);
        this.explain = explain;
    }

    public String getExplain() {
        return explain;
    }

    @JSONField(serialize = false)
    @Override
    public CardType getCardType() {
        return CardType.GROUPON;
    }

    @Override
    public String toString() {
        return "GrouponCoupon [explain=" + explain + ", " + super.toString()
                + "]";
    }
}