package cn.ipokerface.weixin.model.card;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class GiftCoupon extends CardCoupon {
    /**
     * 兑换说明
     */
    @JSONField(name = "gift")
    private final String explain;

    /**
     * 构造兑换券
     *
     * @param couponBaseInfo
     *            基础信息
     * @param explain
     *            兑换说明 如：可兑换音乐木盒一个。
     */
    public GiftCoupon(CouponBase couponBaseInfo, String explain) {
        super(couponBaseInfo);
        this.explain = explain;
    }

    public String getExplain() {
        return explain;
    }

    @JSONField(serialize = false)
    @Override
    public CardType getCardType() {
        return CardType.GIFT;
    }

    @Override
    public String toString() {
        return "GiftCoupon [explain=" + explain + ", " + super.toString() + "]";
    }
}