package cn.ipokerface.weixin.model.card;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class GeneralCoupon extends CardCoupon {
    /**
     * 优惠详情
     */
    @JSONField(name = "default_detail")
    private final String explain;

    /**
     * 构造普通优惠券
     *
     * @param couponBaseInfo
     *            基础信息
     * @param explain
     *            优惠详情 如：音乐木盒
     */
    public GeneralCoupon(CouponBase couponBaseInfo, String explain) {
        super(couponBaseInfo);
        this.explain = explain;
    }

    public String getExplain() {
        return explain;
    }

    @JSONField(serialize = false)
    @Override
    public CardType getCardType() {
        return CardType.GENERAL_COUPON;
    }

    @Override
    public String toString() {
        return "GrouponCoupon [explain=" + explain + ", " + super.toString()
                + "]";
    }
}