package cn.ipokerface.weixin.model.card;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class DiscountCoupon extends CardCoupon {
    /**
     * 打折额度百分比
     */
    private final int discount;

    /**
     * 构造折扣券
     *
     * @param couponBaseInfo
     *            基础信息
     * @param discount
     *            打折额度百分百，如：传入30就是七折。
     */
    public DiscountCoupon(CouponBase couponBaseInfo, int discount) {
        super(couponBaseInfo);
        this.discount = discount;
    }

    public int getDiscount() {
        return discount;
    }

    @JSONField(serialize = false)
    @Override
    public CardType getCardType() {
        return CardType.DISCOUNT;
    }

    @Override
    public String toString() {
        return "DiscountCoupon [discount=" + discount + ", " + super.toString()
                + "]";
    }
}
