package cn.ipokerface.weixin.model.card;

/**
 * Created by       PokerFace
 * Create Date      2019-12-28.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public final class CardCoupons {
    private CardCoupons() {
    }

    /**
     * 卡券基础信息构造器
     *
     * @return
     */
    public static CouponBase.Builder customBase() {
        return new CouponBase.Builder();
    }

    /**
     * 卡券高级信息构造器
     *
     * @return
     */
    public static CouponAdvance.Builder customAdvance() {
        return new CouponAdvance.Builder();
    }

    public static MemberCard.Builder customMemberCard(){
        return  new MemberCard.Builder();
    }
    /**
     * 创建代金券
     *
     * @param builder
     *            卡券基础信息构造器 必填
     * @param reduceCost
     *            减免金额 （单位为元） 必填
     * @param leastCost
     *            起用金额（单位为元）,如果无起用门槛则填0
     */
    public static CardCoupon createCashCoupon(CouponBase.Builder builder,
                                              double reduceCost, double leastCost) {
        CouponBase couponBaseInfo = builder.build();
        CashCoupon coupon = new CashCoupon(couponBaseInfo, reduceCost);
        coupon.setLeastCost(leastCost);
        return coupon;
    }

    /**
     * 创建折扣券
     *
     * @param builder
     *            卡券基础信息构造器 必填
     * @param discount
     *            打折额度百分百，如：传入30就是七折 必填
     */
    public static CardCoupon createDiscountCoupon(
            CouponBase.Builder builder, int discount) {
        CouponBase couponBaseInfo = builder.build();
        DiscountCoupon coupon = new DiscountCoupon(couponBaseInfo, discount);
        return coupon;
    }

    /**
     * 创建普通优惠券
     *
     * @param builder
     *            卡券基础信息构造器 必填
     * @param explain
     *            优惠详情 如：音乐木盒 必填
     */
    public static CardCoupon createGeneralCoupon(
            CouponBase.Builder builder, String explain) {
        CouponBase couponBaseInfo = builder.build();
        GeneralCoupon coupon = new GeneralCoupon(couponBaseInfo, explain);
        return coupon;
    }

    /**
     * 创建普通优惠券
     *
     * @param builder
     *            卡券基础信息构造器 必填
     * @param explain
     *            兑换说明 如：可兑换音乐木盒一个 必填
     */
    public static CardCoupon createGiftCoupon(CouponBase.Builder builder,
                                              String explain) {
        CouponBase couponBaseInfo = builder.build();
        GiftCoupon coupon = new GiftCoupon(couponBaseInfo, explain);
        return coupon;
    }

    /**
     * 创建团购券
     *
     * @param builder
     *            卡券基础信息构造器 必填
     * @param explain
     *            团购详情 如：双人套餐\n -进口红酒一支。\n孜然牛肉一份 必填
     */
    public static CardCoupon createGrouponCoupon(
            CouponBase.Builder builder, String explain) {
        CouponBase couponBaseInfo = builder.build();
        GrouponCoupon coupon = new GrouponCoupon(couponBaseInfo, explain);
        return coupon;
    }


    public static MemberCard createMemberCard(CouponBase.Builder baseBuilder, MemberCard.Builder memberCardBudiler) {
        baseBuilder.build();
        MemberCard memberCard = new MemberCard(baseBuilder.build(), memberCardBudiler);
        return memberCard;
    }
}