package cn.ipokerface.weixin.exception;

import cn.ipokerface.weixin.request.WeixinErrorHolder;
import cn.ipokerface.weixin.utils.StringUtil;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class WeixinException extends Exception {

    private static final long serialVersionUID = 7148145661883468514L;

    private String code;
    private String desc;

    public WeixinException(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public WeixinException(String desc) {
        this.code = "-1";
        this.desc = desc;
    }

    public WeixinException(Throwable e) {
        super(e);
    }

    public WeixinException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getErrorCode() {
        return code;
    }

    public String getErrorDesc() {
        return desc;
    }

    public String getErrorText() {
        return WeixinErrorHolder.getText(code);
    }

    @Override
    public String getMessage() {
        if (StringUtil.isNotBlank(code)) {
            StringBuilder buf = new StringBuilder();
            buf.append(code).append(" >> ").append(desc);
            String text = getErrorText();
            if (StringUtil.isNotBlank(text)) {
                buf.append(" >> ").append(text);
            }
            return buf.toString();
        } else {
            return super.getMessage();
        }
    }
}
