package cn.ipokerface.weixin.collections;

import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public interface MultiValueMap<K, V> extends Map<K, List<V>> {

    /**
     * Return the first value for the given key.
     *
     * @param key
     *            the key
     * @return the first value for the specified key, or {@code null}
     */
    V getFirst(K key);

    /**
     * Add the given single value to the current list of values for the given
     * key.
     *
     * @param key
     *            the key
     * @param value
     *            the value to be added
     */
    void add(K key, V value);

    /**
     * Set the given single value under the given key.
     *
     * @param key
     *            the key
     * @param value
     *            the value to set
     */
    void set(K key, V value);

    /**
     * Set the given values under.
     *
     * @param values
     *            the values.
     */
    void setAll(Map<K, V> values);

    /**
     * Returns the first values contained in this {@code MultiValueMap}.
     *
     * @return a single value representation of this map
     */
    Map<K, V> toSingleValueMap();

}