package cn.ipokerface.weixin.cache;

import cn.ipokerface.redis.JedisClient;
import cn.ipokerface.weixin.utils.SerializationUtils;

import java.util.Set;

/**
 * Created by       PokerFace
 * Create Date      2019-12-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class RedisCacheStorager<T extends Cacheable> implements AbstractCacheStorager<T> {


    private JedisClient jedisClient;
    private String prefix;

    public RedisCacheStorager(JedisClient jedisClient) {
        this(jedisClient,"");
    }

    public RedisCacheStorager(JedisClient jedisClient, String prefix) {
        if (prefix == null || "".equals(prefix)) this.prefix = "weixin_cache_keys:";
        this.prefix = prefix + ":" + "weixin_cache_keys:";
        this.jedisClient = jedisClient;
    }

    public T lookup(String key) {

        String value = jedisClient.get(prefix + key);
        return value != null ? (T) SerializationUtils.deserialize(value.getBytes()) : null;
    }

    public void caching(String key, T cache) {

        String value = String.valueOf(SerializationUtils.serialize(cache));

        if (cache.expiredTime() > 0) {
            jedisClient.set(prefix + key, value , cache.expiredTime());
        }else{
            jedisClient.set(prefix + key, value);
        }

        jedisClient.setsAdd(prefix+ "key_sets", prefix + key);
    }

    public T delete(String key) {
        String value = jedisClient.get(prefix + key);

        jedisClient.setsDelete(prefix+ "key_sets", prefix + key);

        return value != null ? (T) SerializationUtils.deserialize(value.getBytes()) : null;
    }

    public void clear() {
        Set<String> keys = jedisClient.setsValues(prefix+ "key_sets");

        if (keys != null){
            jedisClient.delete(keys.toArray(new String[keys.size()]));
        }
    }
}
