package cn.ipokerface.web.spring.converter;

import cn.ipokerface.common.utils.LocalTimeUtils;
import cn.ipokerface.common.utils.StringUtils;
import org.springframework.core.convert.converter.Converter;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeConverter implements Converter<String, LocalTime> {


    @Override
    public LocalTime convert(String s) {
        if (StringUtils.isEmpty(s)) return null;
        return LocalTime.parse(s, DateTimeFormatter.ofPattern(LocalTimeUtils.fmt_time));
    }
}
