package cn.ipokerface.web.spring.converter;

import cn.ipokerface.common.utils.LocalTimeUtils;
import cn.ipokerface.common.utils.StringUtils;
import org.springframework.core.convert.converter.Converter;

import java.time.LocalDateTime;

public class LocalDateTimeConverter implements Converter<String, LocalDateTime> {


    @Override
    public LocalDateTime convert(String s) {
        if (StringUtils.isEmpty(s)) return null;
        try{
            Long longValue = Long.parseLong(s);
            return LocalTimeUtils.parse(longValue);
        }catch (Exception e){

        }
        return LocalTimeUtils.parse(s);
    }
}
