package cn.ipokerface.web.spring.converter;

import cn.ipokerface.common.utils.LocalTimeUtils;
import cn.ipokerface.common.utils.StringUtils;
import org.springframework.core.convert.converter.Converter;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateConverter implements Converter<String, LocalDate> {
    @Override
    public LocalDate convert(String s) {
        if (StringUtils.isEmpty(s)) return null;
        return LocalDate.parse(s, DateTimeFormatter.ofPattern(LocalTimeUtils.fmt_date));
    }
}
