package cn.ipokerface.web.spring.bind;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;

import javax.servlet.ServletRequest;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServletRequestDataBinder extends org.springframework.web.bind.ServletRequestDataBinder {

    private final Pattern pattern = Pattern.compile("_(\\w)");

    public ServletRequestDataBinder(Object target) {
        super(target);
    }


    @Override
    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
        List<PropertyValue> propertyValueList = mpvs.getPropertyValueList();
        List<PropertyValue> list = new LinkedList<>();
        for (PropertyValue propertyValue: propertyValueList) {
            String name = propertyValue.getName();
            String camelName = this.toCamel(name);
            if (!name.equals(camelName)) {
                list.add(new PropertyValue(camelName, propertyValue.getValue()));
            }
        }
        propertyValueList.addAll(list);
    }


    private String toCamel(final String value) {
        final StringBuffer sb = new StringBuffer();
        Matcher m = pattern.matcher(value);
        while (m.find()){
            m.appendReplacement(sb, m.group(1).toUpperCase());
        }
        m.appendTail(sb);
        return sb.toString();
    }
}
