package cn.ipokerface.web.spring;

import cn.ipokerface.common.fastjson.Fastjson;
import cn.ipokerface.common.utils.LocalTimeUtils;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * Created by       PokerFace
 * Create Date      2019-11-27.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */

@Component
@ConfigurationProperties(prefix = "spring.web")
public class WebMvcProperties {


    /**
     *  enable fast-json message converters.
     */
    private boolean fastjsonEnabled = true;


    /**
     *  fast-json message converter features.
     *                 SerializerFeature.PrettyFormat,
     *                 SerializerFeature.WriteMapNullValue,
     *                 SerializerFeature.WriteEnumUsingToString,
     *                 SerializerFeature.WriteNullListAsEmpty,
     *                 SerializerFeature.WriteNullStringAsEmpty,
     *                 SerializerFeature.SkipTransientField,
     *                 SerializerFeature.WriteEnumUsingToString,
     *                 SerializerFeature.WriteDateUseDateFormat,
     *                 SerializerFeature.WriteNonStringKeyAsString
     */
    private SerializerFeature[] fastjsonFeatures =
            Fastjson.serializerFeatures();


    private String datetimeFormatter = LocalTimeUtils.fmt_date_time;


    private boolean underlineToCamelcaseEnabled = true;



    public boolean isUnderlineToCamelcaseEnabled() {
        return underlineToCamelcaseEnabled;
    }

    public void setUnderlineToCamelcaseEnabled(boolean underlineToCamelcaseEnabled) {
        this.underlineToCamelcaseEnabled = underlineToCamelcaseEnabled;
    }

    public boolean isFastjsonEnabled() {
        return fastjsonEnabled;
    }

    public void setFastjsonEnabled(boolean fastjsonEnabled) {
        this.fastjsonEnabled = fastjsonEnabled;
    }


    public SerializerFeature[] getFastjsonFeatures() {
        return fastjsonFeatures;
    }

    public void setFastjsonFeatures(SerializerFeature[] fastjsonFeatures) {
        this.fastjsonFeatures = fastjsonFeatures;
    }

    public String getDatetimeFormatter() {
        return datetimeFormatter;
    }

    public void setDatetimeFormatter(String datetimeFormatter) {
        this.datetimeFormatter = datetimeFormatter;
    }
}
