package cn.ipokerface.web.controller;

import cn.ipokerface.common.exception.ServiceCodeException;
import cn.ipokerface.common.exception.ServiceResultException;
import cn.ipokerface.common.logback.LoggerAdapter;
import cn.ipokerface.common.model.api.ResultBody;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * Created by       mac
 * Create Date      2020/12/11
 * Version          1.0.0
 * Description:
 */


@Order(Integer.MAX_VALUE)
@Configuration
@ControllerAdvice
public class ControllerExceptionHandler extends LoggerAdapter {

    @ResponseBody
    @ExceptionHandler(value = Exception.class)
    public ResultBody exceptionHandler(Exception ex) {
        // 输出ex日志
        error(ex);

        if (ex instanceof NumberFormatException) {
            return ResultBody.error(ResultBody.CODE_ILLEGAL, ex.getMessage());
        }
        else if (ex instanceof IllegalArgumentException || ex instanceof EnumConstantNotPresentException) {
            return ResultBody.error(ResultBody.CODE_ILLEGAL, ex.getMessage());
        }
        else if (ex instanceof MissingServletRequestParameterException) {
            return ResultBody.error(ResultBody.CODE_ILLEGAL, ex.getMessage());
        }
        else if (ex instanceof HttpRequestMethodNotSupportedException) {
            return ResultBody.error(ResultBody.CODE_ILLEGAL, ex.getMessage());
        }
        else if (ex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException exception = (MethodArgumentNotValidException) ex;
            exception.getBindingResult().getFieldError().getDefaultMessage();
            return ResultBody.error(ResultBody.CODE_ILLEGAL,exception.getBindingResult().getFieldError().getDefaultMessage());
        }
        else if (ex instanceof BindException) {
            BindException exception = (BindException) ex;
            List<ObjectError> errorList = exception.getBindingResult().getAllErrors();
            StringBuffer stringBuffer = new StringBuffer();
            if (CollectionUtils.isNotEmpty(errorList)) {
                errorList.stream().forEach(item->{
                    if (StringUtils.isNotEmpty(stringBuffer.toString())) stringBuffer.append(",");
                    stringBuffer.append(item.getDefaultMessage());
                });
            }
            return ResultBody.error(ResultBody.CODE_ILLEGAL, stringBuffer.toString());
        }
        else if (ex instanceof ServiceResultException) {
            ServiceResultException exception = (ServiceResultException) ex;
            return exception.getBody();
        }
        else if (ex instanceof ServiceCodeException) {
            ServiceCodeException exception = (ServiceCodeException) ex;
            return ResultBody.error(exception.getCode(), exception.getMessage());
        }


        return ResultBody.error();
    }
}
