/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.web.spring;

import cn.ipokerface.common.fastjson.Fastjson;
import cn.ipokerface.web.spring.WebMvcProperties;
import cn.ipokerface.web.spring.bind.ServletModelAttributeMethodProcessor;
import cn.ipokerface.web.spring.converter.LocalDateTimeConverter;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
@EnableConfigurationProperties(value={WebMvcProperties.class})
public class WebAutoConfiguration
extends WebMvcConfigurationSupport {
    @Autowired
    WebMvcProperties webMvcProperties;

    @Bean
    @Primary
    public FastJsonHttpMessageConverter fastJsonHttpMessageConverter() {
        FastJsonHttpMessageConverter fastConvert = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializeConfig(Fastjson.serializeConfig());
        fastJsonConfig.setSerializeFilters(Fastjson.serializeFilters());
        fastJsonConfig.setSerializerFeatures(this.webMvcProperties.getFastjsonFeatures());
        fastJsonConfig.setDateFormat("yyyy-MM-dd HH:mm:ss");
        fastConvert.setFastJsonConfig(fastJsonConfig);
        return fastConvert;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.web.fastjson-enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={HttpMessageConverters.class})
    public HttpMessageConverters fastJsonHttpMessageConverters(FastJsonHttpMessageConverter fastJsonHttpMessageConverter) {
        return new HttpMessageConverters(new HttpMessageConverter[]{fastJsonHttpMessageConverter});
    }

    protected void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new LocalDateTimeConverter());
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        if (this.webMvcProperties.isUnderlineToCamelcaseEnabled()) {
            resolvers.add((HandlerMethodArgumentResolver)new ServletModelAttributeMethodProcessor(true));
        }
    }
}

