/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.web.controller;

import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.web.controller.BaseController;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
@AutoConfigureBefore(value={ErrorMvcAutoConfiguration.class})
public class HandlerController
extends BaseController
implements ErrorController {
    public static final String ERROR_PATH = "/error";
    public static final String ERROR_STATUS = "javax.servlet.error.status_code";

    @RequestMapping(value={"/error"})
    public ResultBody error(HttpServletRequest request, HttpServletResponse response) {
        Object statusObject = request.getAttribute(ERROR_STATUS);
        if (statusObject == null) {
            return ResultBody.error();
        }
        try {
            int statusCode = Integer.parseInt(statusObject.toString());
            switch (statusCode) {
                case 404: {
                    return ResultBody.error((int)20001, (String)String.valueOf(statusCode));
                }
            }
            return ResultBody.error((int)20000, (String)statusObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResultBody.error((int)20000, (String)e.getMessage());
        }
    }

    public String getErrorPath() {
        return ERROR_PATH;
    }
}

