/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.web.controller;

import cn.ipokerface.common.logback.LoggerAdapter;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseController
extends LoggerAdapter {
    protected String getClientIpAddress(HttpServletRequest request) {
        String ip = "";
        try {
            ip = request.getHeader("x-forwarded-for");
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if ((ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) && ((ip = request.getRemoteAddr()).equals("127.0.0.1") || ip.equals("0:0:0:0:0:0:0:1"))) {
                try {
                    InetAddress inet = InetAddress.getLocalHost();
                    ip = inet.getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            return ip.split(",")[0];
        }
        catch (Exception exception) {
            return ip;
        }
    }

    protected void writeFile(HttpServletResponse response, String filePath) throws IOException {
        File file = new File(filePath);
        if (file == null || !file.exists()) {
            return;
        }
        this.writeFile(response, new FileInputStream(file), file.getName());
    }

    protected void writeFile(HttpServletResponse response, InputStream inputStream, String filename) throws IOException {
        String outFile = URLEncoder.encode(filename, "UTF-8");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content-Type", "application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + outFile);
        response.addHeader("Cache-Control", "no-cache");
        FileUtils.writeTo((InputStream)inputStream, (OutputStream)response.getOutputStream());
    }

    protected <T> ResultBody<T> success(T model) {
        return ResultBody.success(model);
    }

    protected ResultBody success() {
        return ResultBody.success();
    }

    protected ResultBody error() {
        return ResultBody.error();
    }

    protected ResultBody error(String message) {
        return ResultBody.error((String)message);
    }

    protected ResultBody error(int code, String message) {
        return ResultBody.error((int)code, (String)message);
    }
}

