/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.web.controller;

import cn.ipokerface.common.exception.ServiceCodeException;
import cn.ipokerface.common.exception.ServiceResultException;
import cn.ipokerface.common.logback.LoggerAdapter;
import cn.ipokerface.common.model.api.ResultBody;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.validation.BindException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@Order(value=0x7FFFFFFF)
@Configuration
@ControllerAdvice
public class ControllerExceptionHandler
extends LoggerAdapter {
    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ResultBody exceptionHandler(Exception ex) {
        this.error(ex);
        if (ex instanceof NumberFormatException) {
            return ResultBody.error((int)ResultBody.Result.ERROR_ARGUMENT.getCode(), (String)ex.getMessage());
        }
        if (ex instanceof IllegalArgumentException || ex instanceof EnumConstantNotPresentException) {
            return ResultBody.error((int)ResultBody.Result.ERROR_ARGUMENT.getCode(), (String)ex.getMessage());
        }
        if (ex instanceof MissingServletRequestParameterException) {
            return ResultBody.error((int)ResultBody.Result.ERROR_ARGUMENT.getCode(), (String)ex.getMessage());
        }
        if (ex instanceof HttpRequestMethodNotSupportedException) {
            return ResultBody.error((int)ResultBody.Result.ERROR_METHOD.getCode(), (String)ex.getMessage());
        }
        if (ex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException exception = (MethodArgumentNotValidException)ex;
            exception.getBindingResult().getFieldError().getDefaultMessage();
            return ResultBody.error((int)ResultBody.Result.ERROR_ARGUMENT.getCode(), (String)exception.getBindingResult().getFieldError().getDefaultMessage());
        }
        if (ex instanceof BindException) {
            BindException exception = (BindException)ex;
            List errorList = exception.getBindingResult().getAllErrors();
            StringBuffer stringBuffer = new StringBuffer();
            if (CollectionUtils.isNotEmpty((Collection)errorList)) {
                errorList.stream().forEach(item -> {
                    if (StringUtils.isNotEmpty((CharSequence)stringBuffer.toString())) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(item.getDefaultMessage());
                });
            }
            return ResultBody.error((int)ResultBody.Result.ERROR_ARGUMENT.getCode(), (String)stringBuffer.toString());
        }
        if (ex instanceof ServiceResultException) {
            ServiceResultException exception = (ServiceResultException)ex;
            return exception.getBody();
        }
        if (ex instanceof ServiceCodeException) {
            ServiceCodeException exception = (ServiceCodeException)ex;
            return ResultBody.error((int)exception.getCode(), (String)exception.getMessage());
        }
        return ResultBody.error();
    }
}

