package cn.ipokerface.web.spring;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * Created by       PokerFace
 * Create Date      2019-11-27.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */

@Component
@ConfigurationProperties(prefix = "spring.web.converters")
public class WebConvertersProperties {


    /**
     *  enable fast-json message converters.
     */
    private boolean fastJsonEnabled = true;


    /**
     *  fast-json message converter features.
     *                 SerializerFeature.PrettyFormat,
     *                 SerializerFeature.WriteMapNullValue,
     *                 SerializerFeature.WriteEnumUsingToString,
     *                 SerializerFeature.WriteNullListAsEmpty,
     *                 SerializerFeature.WriteNullStringAsEmpty,
     *                 SerializerFeature.SkipTransientField,
     *                 SerializerFeature.WriteEnumUsingToString,
     *                 SerializerFeature.WriteDateUseDateFormat,
     *                 SerializerFeature.WriteNonStringKeyAsString
     */
    private String fastJsonFeatures = "PrettyFormat,WriteNullNumberAsZero,WriteEnumUsingToString,WriteNullStringAsEmpty,WriteNonStringKeyAsString,WriteNullListAsEmpty,DisableCircularReferenceDetect,WriteDateUseDateFormat";


    /**
     *  fast-json converter long value to string .default true
     */
    private boolean longToStringEnabled = true;


    private String datetimeFormatter = "yyyy-MM-dd HH:mm:ss";


    public boolean isFastJsonEnabled() {
        return fastJsonEnabled;
    }

    public void setFastJsonEnabled(boolean fastJsonEnabled) {
        this.fastJsonEnabled = fastJsonEnabled;
    }

    public String getFastJsonFeatures() {
        return fastJsonFeatures;
    }

    public void setFastJsonFeatures(String fastJsonFeatures) {
        this.fastJsonFeatures = fastJsonFeatures;
    }

    public boolean isLongToStringEnabled() {
        return longToStringEnabled;
    }

    public void setLongToStringEnabled(boolean longToStringEnabled) {
        this.longToStringEnabled = longToStringEnabled;
    }

    public String getDatetimeFormatter() {
        return datetimeFormatter;
    }

    public void setDatetimeFormatter(String datetimeFormatter) {
        this.datetimeFormatter = datetimeFormatter;
    }
}
